/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import com.quantumdata.autoupdate.WebInterface;
import com.quantumdata.autoupdate.WebInterfaceException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DownloadUpgradeScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String doneCmd = "DONE";
    private JProgressBar m_progressBar;
    private JLabel m_txtInstruction;
    private Device88X m_Dev88X;
    private Action m_act;
    private Thread m_netThread;
    private WebInterface m_theWeb;

    public DownloadUpgradeScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying Web Data Address Window");
        super.finalize();
        this.m_progressBar = null;
        this.m_theWeb = null;
        this.m_txtInstruction = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_txtInstruction = new JLabel("<html><body><p align=\"center\">Downloading Upgrade File from the Quantum Data Website.</p></body></html>");
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(false);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Next (Test Purposes Only)");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('N');
        jButton2.setActionCommand("DONE");
        jButton2.addActionListener(actionListener);
        jButton2.setVisible(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtInstruction, gridBagConstraints);
        jPanel.add(this.m_txtInstruction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 0);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("DONE".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = device88X.isUsePCMCIA() ? (device88X.isSkipBackupFlagSet() ? 17 : 11) : 8;
            System.out.println("Going to Backup Location Screen: ID=" + n2);
        }
        return n2;
    }

    public void run(Device88X device88X) {
        this.m_Dev88X = device88X;
        this.m_netThread = new Thread(new runGetWebFileThread(super.getJFrame()));
        this.m_netThread.setName("Download Web Thread");
        this.m_netThread.start();
    }

    public void refresh() {
        super.refresh();
    }

    private String getFileNameNoExt(String string) {
        String[] stringArray = string.split("[.]");
        return stringArray[stringArray.length - 2];
    }

    private String getFileName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        return string2;
    }

    private void makePath(String string) {
        File file = new File(string);
        File file2 = null;
        file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    protected final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    class runGetWebFileThread
    implements Runnable {
        private JFrame runFrame;

        public runGetWebFileThread(JFrame jFrame) {
            this.runFrame = jFrame;
        }

        public synchronized void run() {
            int n;
            Object object;
            String string;
            ActionEvent actionEvent = new ActionEvent(this, 1001, "DONE");
            DownloadUpgradeScreen.this.m_act.setEnabled(true);
            if (!DownloadUpgradeScreen.this.m_Dev88X.useLocalZipFile()) {
                try {
                    System.out.println("Attempting to download: " + DownloadUpgradeScreen.this.m_Dev88X.getUpgradeURL());
                    DownloadUpgradeScreen.this.m_theWeb = new WebInterface(DownloadUpgradeScreen.this.m_Dev88X, DownloadUpgradeScreen.this.m_Dev88X.getUpgradeURL(), 1);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        JOptionPane.showMessageDialog(this.runFrame, "Bad URL: " + DownloadUpgradeScreen.this.m_theWeb.getURL(), "Bad URL", 0);
                    }
                    catch (NullPointerException nullPointerException) {
                        JOptionPane.showMessageDialog(this.runFrame, "Bad URL: null \nExiting", "Bad URL", 0);
                    }
                    System.out.println("Exiting");
                    System.exit(0);
                }
                try {
                    DownloadUpgradeScreen.this.m_theWeb.downloadUpdate(this.runFrame, DownloadUpgradeScreen.this.m_progressBar, DownloadUpgradeScreen.this.m_txtInstruction, DownloadUpgradeScreen.this.m_Dev88X);
                }
                catch (WebInterfaceException webInterfaceException) {
                    string = "Error";
                    object = "Error";
                    int n2 = 0;
                    if (webInterfaceException.getWebResponseCode() > 0) {
                        object = "Web Error";
                        string = "Web Host returned an code of " + webInterfaceException.getWebResponseCode() + "\n" + webInterfaceException.getWebResponseMessage();
                        n2 = 1;
                    }
                    JOptionPane.showMessageDialog(this.runFrame, string, (String)object, n2);
                    System.out.println("Exiting");
                    System.exit(0);
                }
                DownloadUpgradeScreen.this.refresh();
                Thread.yield();
            }
            if ((n = JOptionPane.showOptionDialog(this.runFrame, string = DownloadUpgradeScreen.this.m_Dev88X.useLocalZipFile() ? "Software upgrade downloaded locally \n\nContinue with the upgrade?" : "The Downloaded Software Versions: " + DownloadUpgradeScreen.this.m_Dev88X.getDownloadSWVersion() + "  \n\n" + "Continue With The Upgrade?\n\n", "Continue With Upgrade?", 1, 3, null, object = new Object[]{"Yes", "Cancel Upgrade"}, object[0])) == 1) {
                System.out.println("Exiting");
                System.exit(0);
            }
            if (n == 0) {
                DownloadUpgradeScreen.this.m_txtInstruction.setText("Extracting the Upgrade files");
                DownloadUpgradeScreen.this.refresh();
                String string2 = "";
                int n3 = 0;
                try {
                    ZipFile zipFile = new ZipFile(DownloadUpgradeScreen.this.m_Dev88X.getZipFilePath());
                    String string3 = DownloadUpgradeScreen.this.getFileNameNoExt(DownloadUpgradeScreen.this.getFileName(DownloadUpgradeScreen.this.m_Dev88X.getZipFilePath()));
                    String string4 = "./downloads/" + string3;
                    File file = new File(string4);
                    DownloadUpgradeScreen.this.m_Dev88X.setUnzippedPath(string4);
                    if (file.exists()) {
                        System.out.println("Unzip Directory already exists, deleting directory.");
                        DownloadUpgradeScreen.this.m_Dev88X.deleteFolder(string4, DownloadUpgradeScreen.this.m_txtInstruction, DownloadUpgradeScreen.this.m_progressBar);
                    }
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    n3 = 0;
                    DownloadUpgradeScreen.this.m_progressBar.setValue(n3);
                    DownloadUpgradeScreen.this.m_progressBar.setMaximum(zipFile.size());
                    while (enumeration.hasMoreElements()) {
                        String string5;
                        ZipEntry zipEntry = enumeration.nextElement();
                        ++n3;
                        if (zipEntry.isDirectory()) {
                            string2 = "Extracting directory: " + zipEntry.getName();
                            System.out.println(string2);
                            DownloadUpgradeScreen.this.m_txtInstruction.setText(string2);
                            DownloadUpgradeScreen.this.m_progressBar.setValue(n3);
                            DownloadUpgradeScreen.this.refresh();
                            string5 = string4 + "/" + zipEntry.getName();
                            new File(string5).mkdirs();
                            continue;
                        }
                        if (zipEntry.getName().endsWith("bootrom_uncmp.hex")) {
                            DownloadUpgradeScreen.this.m_Dev88X.setBootRomUpgradeFlag(true);
                        }
                        string2 = "Extracting file: " + zipEntry.getName();
                        System.out.println(string2);
                        DownloadUpgradeScreen.this.m_txtInstruction.setText(string2);
                        DownloadUpgradeScreen.this.m_progressBar.setValue(n3);
                        DownloadUpgradeScreen.this.refresh();
                        string5 = string4 + "/" + zipEntry.getName();
                        DownloadUpgradeScreen.this.makePath(string5);
                        DownloadUpgradeScreen.this.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(string5)));
                        Thread.yield();
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.runFrame, "Zip File " + DownloadUpgradeScreen.this.m_Dev88X.getZipFilePath() + " Not Found", "Upgrade File Not Found", 0);
                }
            }
            DownloadUpgradeScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

